###################################################
### code chunk number : set your work directory
###################################################
## 
## Firstly, set your work directory to contain "main_marginal_densities.R".
## Secondly, make sure there is a folder named "figure"
## in the same directory of "main_marginal_densities.R".
##


####################################################
### code chunk number : Simulations: Marginal density, alpha = 3, beta = 1
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")
library(gsl)

## initialization
set.seed(1)
alpha = 3             ## hyperparameter
beta = 1              ## hyperparameter

x = seq(0.01, 10, by = 0.01)
md = Marginal_density_alpha_beta(x, alpha, beta)

dev.new()
col = 1:1
lty = 1:1
xlim = range(x); xlim
ylim = range(md); ylim
plot(x, md, type = "n", xlim = xlim, ylim = ylim, xlab = expression(x), ylab = "Marginal density")
lines(x, md,  lty = lty[1], col = col[1], lwd = 4)
# title(Title)
leg.txt = c(expression(paste(alpha, " = 3, ", beta, " = 1", sep = "")))
legend("topright", legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = paste("figure/U-IG_md_x", sep=""), type = c("pdf"))
savePlot(filename = paste("figure/U-IG_md_x", sep=""), type = c("jpg"))


####################################################
### code chunk number : Simulations: Marginal density, alpha changes
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")
library(gsl)

## initialization
alpha = c(2.5, 3, 5, 10) ## hyperparameter
beta = 1                 ## hyperparameter

x = seq(0.01, 2, by = 0.01)
md1 = Marginal_density_alpha_beta(x, alpha = alpha[1], beta); 
md2 = Marginal_density_alpha_beta(x, alpha = alpha[2], beta); 
md3 = Marginal_density_alpha_beta(x, alpha = alpha[3], beta); 
md4 = Marginal_density_alpha_beta(x, alpha = alpha[4], beta); 

dev.new()
col = c("black", "red", "blue", "purple")
lty = 1:4
xlim = range(x); xlim
ylim = range(md1, md2, md3, md4); ylim
plot(x, md1, type = "n", xlim = xlim, ylim = ylim, xlab = expression(x), ylab = "Marginal density")
lines(x, md1,  lty = lty[1], col = col[1], lwd = 4)
lines(x, md2,  lty = lty[2], col = col[2], lwd = 4)
lines(x, md3,  lty = lty[3], col = col[3], lwd = 4)
lines(x, md4,  lty = lty[4], col = col[4], lwd = 4)
# title(Title)
leg.txt = c(
expression(paste(alpha, " = 2.5", sep = "")),
expression(paste(alpha, " = 3", sep = "")),
expression(paste(alpha, " = 5", sep = "")),
expression(paste(alpha, " = 10", sep = ""))
)
legend("topright", legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = paste("figure/U-IG_md_x_alpha_changes", sep=""), type = c("pdf"))
savePlot(filename = paste("figure/U-IG_md_x_alpha_changes", sep=""), type = c("jpg"))


####################################################
### code chunk number : Simulations: Marginal density, beta changes
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")
library(gsl)

## initialization
alpha = 3               ## hyperparameter
beta = c(0.5, 1, 3, 5)  ## hyperparameter

x = seq(0.01, 2, by = 0.01)
md1 = Marginal_density_alpha_beta(x, alpha, beta = beta[1]); 
md2 = Marginal_density_alpha_beta(x, alpha, beta = beta[2]); 
md3 = Marginal_density_alpha_beta(x, alpha, beta = beta[3]); 
md4 = Marginal_density_alpha_beta(x, alpha, beta = beta[4]); 

dev.new()
col = c("black", "red", "blue", "purple")
lty = 1:4
xlim = range(x); xlim
ylim = range(md1, md2, md3, md4); ylim
plot(x, md1, type = "n", xlim = xlim, ylim = ylim, xlab = expression(x), ylab = "Marginal density")
lines(x, md1,  lty = lty[1], col = col[1], lwd = 4)
lines(x, md2,  lty = lty[2], col = col[2], lwd = 4)
lines(x, md3,  lty = lty[3], col = col[3], lwd = 4)
lines(x, md4,  lty = lty[4], col = col[4], lwd = 4)
# title(Title)
leg.txt = c(
expression(paste(beta, " = 0.5", sep = "")),
expression(paste(beta, " = 1", sep = "")),
expression(paste(beta, " = 3", sep = "")),
expression(paste(beta, " = 5", sep = ""))
)
legend("topright", legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = paste("figure/U-IG_md_x_beta_changes", sep=""), type = c("pdf"))
savePlot(filename = paste("figure/U-IG_md_x_beta_changes", sep=""), type = c("jpg"))

